<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;

class NotificationController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        
        $notifications = Notification::where('user_id', $user->id);
        
        if($request->has('status') && !empty($request->status))
        {
            $notification->where('status', $request->status);
        }
        
        if($request->has('read)') && !empty($request->read))
        {
            $notification->where('read', $request->read);
        }
        
        return response()->json([
            'success' => true,
            'message' => 'User notifications.',
            'data' => $notifications->get(),
        ]);
    }
}
