<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\FeaturedBrand;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $featured_categories = Category::where('is_featured', 1)
            ->where('status', 1)
            ->where('level', 0)
            ->orderBy('order_no', 'asc')
            ->get();

        $featured_brands = Brand::where('status', 1)
        ->where('is_featured', 1)
        ->orderBy('order_no', 'asc')
        ->get();

        $featured_products = Product::where('status', 1)->where('is_featured', 1)->with('category', 'brand', 'unit', 'label', 'productImages', 'attributes')
        ->orderBy('id', 'desc')
        ->limit(16)->get()
        ->map(function ($product) {
            $product->unit_price = \App\Helpers\ProductsHelper::getProductPrice($product, true);
            return $product;
        });

        $setting = [
            'show_price' => get_setting('show_price'),
        ];


        return response()->json([
            'success' => true,
            'message' => 'Home data fetched successfully.',
            'data' => [
                'featured_categories' => $featured_categories,
                'featured_brands' => $featured_brands,
                'featured_products' => $featured_products,
                'setting' => $setting,
            ],
        ]);


    }
}
