<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\PickupAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class UserAddressController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();
        return response()->json([
            'success' => true,
            'message' => 'User addresses.',
            'data' => $user->addresses,
        ]);
    }

    public function store(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'address_line_1' => 'required',
            'address_line_2' => 'nullable',
            'city' => 'required',
            'post_code' => 'required',
            'phone' => 'required',
            'type' => 'required|in:shipping,billing',
            'is_default' => 'required|boolean',
        ]);

        if ($validate->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation Error.',
                'data' => $validate->errors(),
            ], 422);
        }

        $user = $request->user();
        $address = $user->addresses()->create($request->all());

        if($request->is_default){
            $user->addresses()->where('id', '!=', $address->id)->update(['is_default' => false]);
        }

        return response()->json([
            'success' => true,
            'message' => 'Address added successfully.',
            'data' => $address,
        ]);
    }

    public function update(Request $request, $id)
    {
        $validate = Validator::make($request->all(), [
            'first_name' => 'required',
            'last_name' => 'required',
            'address_line_1' => 'required',
            'address_line_2' => 'nullable',
            'city' => 'required',
            'post_code' => 'required',
            'phone' => 'required',
            'type' => 'required|in:shipping,billing',
            'is_default' => 'required|boolean',
        ]);

        if ($validate->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation Error.',
                'data' => $validate->errors(),
            ], 422);
        }

        $user = $request->user();
        $address = $user->addresses()->find($id);

        if(!$address){
            return response()->json([
                'success' => false,
                'message' => 'Address not found.',
                'data' => null,
            ], 404);
        }

        $address->update($request->all());

        if($request->is_default){
            $user->addresses()->where('id', '!=', $address->id)->update(['is_default' => false]);
        }

        return response()->json([
            'success' => true,
            'message' => 'Address updated successfully.',
            'data' => $address,
        ]);
    }

    public function destroy(Request $request, $id)
    {
        $user = $request->user();
        $address = $user->addresses()->find($id);

        if(!$address){
            return response()->json([
                'success' => false,
                'message' => 'Address not found.',
                'data' => null,
            ], 404);
        }

        $address->delete();

        return response()->json([
            'success' => true,
            'message' => 'Address deleted successfully.',
        ]);
    }

    public function setDefault(Request $request, $id)
    {
        $user = $request->user();
        $address = $user->addresses()->find($id);

        if(!$address){
            return response()->json([
                'success' => false,
                'message' => 'Address not found.',
                'data' => null,
            ], 404);
        }

        $user->addresses()->where('id', '!=', $address->id)
        ->where('type', $address->type)
        ->update(['is_default' => false]);
        $address->update(['is_default' => true]);

        return response()->json([
            'success' => true,
            'message' => 'Default address set successfully.',
            'data' => $address,
        ]);
    }


    public function pickup(Request $request)
    {

        return response()->json([
            'success' => true,
            'message' => 'User pickup addresses.',
            'data' => PickupAddress::where('status', 1)->get(),
        ]);
    }
}
